@extends('user')
@section('style')
<style>
    .credit-card-box .form-control.error {
        border-color: red;
        outline: 0;
        box-shadow: inset 0 1px 1px rgba(0, 0, 0, 0.075), 0 0 8px rgba(255, 0, 0, 0.6);
    }

    .credit-card-box label.error {
        font-weight: bold;
        color: red;
        padding: 2px 8px;
        margin-top: 2px;
    }
</style>
@stop
@section('content')
    @include('partials.breadcrumb')




    <!-- login begin-->
    <div class="contact login">
        <div class="container">

            <div class="row justify-content-center">
                <div class="col-xl-12 col-lg-12">
                    <div class="card">
                        <div class="card-body">
                            <div class="section-title text-center">
                                <h2>@lang('Stripe Payment')</h2>
                                <div class="card-wrapper"></div>
                                <br><br>
                            </div>

                            @include('errors.alert')
                            <form role="form" id="payment-form" method="POST" action="{{ route('ipn.stripe')}}">
                                {{csrf_field()}}
                                <input type="hidden" value="{{ $track }}" name="track">

                                <div class="row">

                                    <div class="col-xl-6 col-lg-6">
                                        <div class="form-group">
                                            <label for="name">@lang('CARD NAME')</label>
                                            <div class="input-group input-group-lg">
                                                <input type="text" class="form-control" name="name" placeholder="Card Name" autocomplete="off" autofocus/>
                                                <div class="input-group-prepend">
                                                <span class="input-group-text" id="inputGroup-sizing-default">
                                                    <i class="fa fa-font"></i>
                                                </span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>


                                    <div class="col-xl-6 col-lg-6">
                                        <div class="form-group">
                                            <label for="cardNumber">@lang('CARD NUMBER')</label>
                                            <div class="input-group input-group-lg">
                                                <input type="tel" class="form-control" name="cardNumber" placeholder="Valid Card Number" autocomplete="off"
                                                       required autofocus/>
                                                <div class="input-group-prepend">
                                            <span class="input-group-text" id="inputGroup-sizing-default">
                                                <i class="fa fa-credit-card"></i>
                                            </span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>



                                    <div class="col-xl-6 col-lg-6">
                                        <div class="form-group">
                                            <label for="cardExpiry">@lang('EXPIRATION DATE')</label>
                                            <input type="tel" class="form-control form-control-lg" name="cardExpiry" placeholder="MM / YYYY" autocomplete="off" required/>
                                        </div>
                                    </div>

                                    <div class="col-xl-6 col-lg-6">
                                        <div class="form-group">
                                            <label for="cardCVC">@lang('CVC CODE')</label>
                                            <input type="tel" class="form-control form-control-lg" name="cardCVC" placeholder="CVC" autocomplete="off" required />
                                        </div>
                                    </div>




                                    <div class="col-xl-12 col-lg-12">
                                        <button type="submit" class="custom-button btn btn-lg btn-success btn-block">@lang('PAY NOW')</button>
                                    </div>


                                </div>
                            </form>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
    <!-- login end -->

@stop

@section('script')
    <script type="text/javascript" src="https://rawgit.com/jessepollak/card/master/dist/card.js"></script>

    <script>
        (function ($) {
            $(document).ready(function () {
                var card = new Card({
                    form: '#payment-form',
                    container: '.card-wrapper',
                    formSelectors: {
                        numberInput: 'input[name="cardNumber"]',
                        expiryInput: 'input[name="cardExpiry"]',
                        cvcInput: 'input[name="cardCVC"]',
                        nameInput: 'input[name="name"]'
                    }
                });
            });
        })(jQuery);
    </script>
@stop


